/*****************************************************************************
*  LPC11E6x RC5 decoder program
*
*  1. Use SCT1 timer to capture and decode RC5 messages
*  2. Use UART to print received RC5 frames to PC terminal
*****************************************************************************/
#include "LPC11U6x.h"
#include "global.h"

int main (void) 
{
    LPC_SYSCON->SYSAHBCLKCTRL |= (1u << 16)            // enable clock for IOCON
                               | (1u << 31);           // enable clock for SCT0/1

    LPC_IOCON->PIO2_8  = 0x00000081;                   // P2_8  is SCT1_IN0  = PWM signal input

    USART0_Init(19200);
    RC5_Init();

    PrintString("\f\nLPC800 SCT-RC5 test Januari 2013\n\n");

    while (1)
    {
        if (RC5_flag)                                  // wait for RC5 code
        {
            RC5_flag = 0;                              // clear flag
            PrintString("RC5 = ");                     // and print it
            PrintByte(RC5_System);
            PrintString(" ");
            PrintByte(RC5_Command);
            PrintString("\n");
        }
    }
}
